********************************************************
*** Figure 1 and 2: Behaviour around financial crisis ***
********************************************************
clear all
use "$dataPath\Data"
do "$codePath\Transforming_variables"
xtset country_id period
cd "$outputFigures"

*** Figure 1 ***

* Help variable to find period around crisis
gen crisis_cycle = .
replace crisis_cycle = 0 if start_crisis == 1
forvalues i=1(1)16 {
	replace crisis_cycle = `i' if start_crisisl`i' == 1
	}
forvalues i=1(1)16 {
	replace crisis_cycle = -`i' if start_crisisf`i' == 1
	}	 

* Event window is +/- 4 years around the crisis

local quarterstart=-16															//start of quarterly window
local quarterend=16																//end of quarterly window

tsset country_id period, quarterly	
local start=`quarterstart'
local end=`quarterend'

* Generating the dummyvariables (distance from the crisis)
forvalues i=-16(1)16 {
		if `i'<0	{
			local j=-`i'
			qui generate bcrisis`j'=F`j'.start_crisis							 
			qui replace bcrisis`j'=0 if bcrisis`j'==.
		}
		else {
			qui generate bcrisisL`i'=L`i'.start_crisis 
			qui replace bcrisisL`i'=0 if bcrisisL`i'==.
		}
	}
			 

foreach var in dlogreal_pcredit dlogreal_hcredit dlogreal_nfecredit dlogreal_hp dlogwholesale_assets ///
			   dpcredit_gdp dhcredit_gdp dnfecredit dhp_disp_inc dwholesale_assets ///
			   pcredit_gdp_gap hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap wholesale_gap ///
			   dlogrGDP gdp_gap {
	replace `var' = 100*`var'
	}

	
* Naming variables appearing in Figure 1
	
label variable dlogreal_pcredit "Real private credit (yoy growth)"
label variable dlogreal_hcredit "Real household credit (yoy growth)"
label variable dlogreal_nfecredit "Real NFE credit (yoy growth)"
label variable dlogreal_hp "Real house prices (yoy growth)"
label variable dlogwholesale_assets "Non-core funding (yoy growth)"

label variable dpcredit_gdp "Private credit-to-GDP (yoy change)"
label variable dhcredit_gdp "Household credit-to-GDP (yoy change)"
label variable dnfecredit_gdp "NFE credit-to-GDP (yoy change)"
label variable dhp_disp_inc "House prices-to-income (yoy change)"
label variable dwholesale_assets "Non-core funding ratio (yoy change)"

label variable pcredit_gdp_gap "Private credit-to-GDP gap"	
label variable hcredit_gdp_gap "Household credit-to-GDP gap"
label variable nfecredit_gdp_gap "NFE credit-to-GDP gap"	
label variable hp_inc_gap "House prices-to-income gap"		
label variable wholesale_gap "Non-core funding gap"		


* This part produces Figure 1
set more off
gen zero = 0
foreach var in dlogreal_pcredit dlogreal_hcredit dlogreal_nfecredit dlogreal_hp dlogwholesale_assets ///
			dpcredit_gdp dhcredit_gdp dnfecredit_gdp dhp_disp_inc dwholesale_assets ///
			pcredit_gdp_gap hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap wholesale_gap {
			   
local graphtitle : variable label `var' 										// Graphtitle
xtreg `var' bcrisis*, fe vce(robust) 											// The regression

coefplot, vertical drop(_cons) recast(line) col("221 34 45") lpattern(dash) xline(0, lcolor(black) lpattern(dash)) /// legend(order(2  "95 % CI") ring(0)  pos(11) region(fcolor(none) lcolor(none))) ///
		  xlabel(, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		  graphregion(color(white)) plotregion(lcolor(black) lpattern(solid)) ///
		  relocate(bcrisis16 = -16 bcrisis15 = -15  bcrisis14 = -14 bcrisis13=-13 ///
		  bcrisis12 = -12 bcrisis11 = -11 bcrisis10 = -10 bcrisis9=-9 ///
		  bcrisis8 = -8 bcrisis7 = -7 bcrisis6 = -6 bcrisis5=-5 ///
		  bcrisis4 = -4 bcrisis3 = -3 bcrisis2 = -2 bcrisis1=-1 ///
		  bcrisisL0 = 0 bcrisisL1 = 1 bcrisisL2 = 2 bcrisisL3=3 ///
		  bcrisisL4 = 4 bcrisisL5 = 5 bcrisisL6 = 6 bcrisisL7=7 ///
		  bcrisisL8 = 8 bcrisisL9 = 9 bcrisisL10 = 10 bcrisisL11=11 ///
		  bcrisisL12 = 12 bcrisisL13 = 13 bcrisisL14 = 14 bcrisisL15=15 bcrisisL16=16) ///
		  citop ciopts(recast(rcap) color("44 115 153")) title(`graphtitle') xtitle(Quarters around the crisis) ytitle(Percentage points) yline(0, lcolor(black) lpattern(dash)) /// title(`graphtitle', size(3.5))
 		  xlabel(-16(4)16) addplot((line zero crisis_cycle, sort col(black) lpattern(dash))) scale(1.55) ///
		  saving(`var', replace) 
		  graph export `var'.pdf, replace
		  }


* This part produces Figure 2
set more off
foreach var in dlogrGDP gdp_gap {
			   
local graphtitle : variable label `var' 										// Graphtitle

xtreg `var' bcrisis*, fe vce(robust) 											// The regression

coefplot, vertical drop(_cons) recast(line) col("221 34 45") lpattern(dash) xline(0, lcolor(black) lpattern(dash)) /// legend(order(2  "95 % CI") ring(0)  pos(11) region(fcolor(none) lcolor(none))) ///
		  xlabel(, tposition(inside)) ylabel(, ticks tposition(inside) nogrid) ///
		  graphregion(color(white)) plotregion(lcolor(black) lpattern(solid)) ///
		  relocate(bcrisis16 = -16 bcrisis15 = -15  bcrisis14 = -14 bcrisis13=-13 ///
		  bcrisis12 = -12 bcrisis11 = -11 bcrisis10 = -10 bcrisis9=-9 ///
		  bcrisis8 = -8 bcrisis7 = -7 bcrisis6 = -6 bcrisis5=-5 ///
		  bcrisis4 = -4 bcrisis3 = -3 bcrisis2 = -2 bcrisis1=-1 ///
		  bcrisisL0 = 0 bcrisisL1 = 1 bcrisisL2 = 2 bcrisisL3=3 ///
		  bcrisisL4 = 4 bcrisisL5 = 5 bcrisisL6 = 6 bcrisisL7=7 ///
		  bcrisisL8 = 8 bcrisisL9 = 9 bcrisisL10 = 10 bcrisisL11=11 ///
		  bcrisisL12 = 12 bcrisisL13 = 13 bcrisisL14 = 14 bcrisisL15=15 bcrisisL16=16) ///
		  citop ciopts(recast(rcap) color("44 115 153")) title("") xtitle(Quarters around the crisis) ytitle(Percentage points) yline(0, lcolor(black) lpattern(dash)) /// title(`graphtitle', size(3.5))
		  xlabel(-16(4)16) addplot((line zero crisis_cycle, sort col(black) lpattern(dash))) scale(1.4) ///
		  saving(`var', replace) 
		  graph export `var'.pdf, replace
		  }		  

		  
		  
		  
		  
